#!/usr/bin/python
import sys

SECTOR_LENGTH = 256
SECTOR_LENGTH_CODE = '01'

NUM_TRACKS = 40
NUM_SECTORS = 9


GAP0 = 40
GAP1 = 26
GAP2 = 11
GAP3 = 27
GAP4 = 512 #doesn't matter, as long as there is enough to fill the disk
SYNC = 6

EMPTY_DATA = 'E5'

############################################################

for i in range(0, NUM_TRACKS):

    #start with track number
    out_string = "{:02d}:".format(i)

    #gap 0
    out_string += 'FF ' * GAP0

    #sync
    out_string += '00 ' * SYNC

    #index mark
    out_string += 'FC '

    #gap 1
    out_string += 'FF ' * GAP1

    for j in range(1, NUM_SECTORS + 1):
        #sync
        out_string += '00 ' * SYNC

        #ID Address Mark
        out_string += 'FE '

        #track number
        out_string += "{:02X} ".format(i)

        #side (00)
        out_string += '00 '

        #sector number
        out_string += "{:02X} ".format(j)

        #sector length
        out_string += SECTOR_LENGTH_CODE + ' '

        #ID field CRC. Writing F7 to the controller will produce 2 bytes on disk
        out_string += 'F7 '

        #zero before gap 2. Not in the IBM format, but on the HP disk
        #out_string += '00 '

        #gap 2
        out_string += 'FF ' * GAP2

        #sync
        out_string += '00 ' * SYNC

        #Data Address Mark
        out_string += 'FB '

        #Sector data
        out_string += (EMPTY_DATA + ' ') * SECTOR_LENGTH

        #Data CRC. Writing F7 to the controller will produce 2 bytes on disk
        out_string += 'F7 '

        #gap 3
        out_string += 'FF ' * GAP3


    #gap 4
    out_string += 'FF ' * GAP4

    print(out_string)


