/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
 * Agilent / Keysight U1273A display interface adapter
 * 
 * Testbench
 *
 * http://www.kitsune-denshi.net
 *
 * See LICENSE.txt
 *
 * Version history:
 * v0.1  2021-02-12 initial relase, covers functions of v0.1 HDL
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

`timescale 1ns / 1ps

module test;

  reg in_res;
  reg in_read;
  reg in_write;
  reg in_dc;
  
  wire out_res;
  wire out_read;
  wire out_write;
  wire out_dc;
  wire out_cs;	  
  
  wire [1:0] debug;

  reg [7:0] in_data;
  wire [7:0] out_data;
  
  displayif dut(in_data, in_res, in_read, in_write, in_dc, out_data, out_res, out_read, out_write, out_dc, out_cs, debug);
  
  initial begin	   
    in_res = 1'b1;
    #1 
    in_res = 1'b0;
    #2
    in_res = 1'b1;
    #8
    in_dc = 1'b0;
    in_data = 8'hA0;
    #5
    in_data = 8'hB4;
    #5
    in_data = 8'h08;
    #5
    in_data = 8'h11;
    #5
    in_data = 8'hB3;
    #5
    in_data = 8'h00;
    #5
    in_data = 8'h11;	
    #5
    in_data = 8'hB2;
    #5
    in_data = 8'h00;
    #5
    in_data = 8'h10;
    #5			
    in_dc = 1'b1;
    in_data = 8'h12;
    #5
    in_data = 8'h34;
    #5
    in_data = 8'h56;   
    #5
    in_data = 8'h78;
    #5
    in_dc = 1'b0;
    in_data = 8'hB1;
    #5
    in_data = 8'h01;
    #5
    in_data = 8'h10;
    #5			
    in_dc = 1'b1;
    in_data = 8'h12;
    #5
    in_data = 8'h34;
    #5
    in_data = 8'h56;   
    #5
    in_data = 8'h78;
    #5
    in_dc = 1'b0;
    in_data = 8'hB0;
    #5
    in_data = 8'h01;
    #5
    in_data = 8'h1F;
    #5			
    in_dc = 1'b1;
    in_data = 8'h12;
    #5
    in_data = 8'h34;
    #5
    in_data = 8'h56;   
    #5
    in_data = 8'h78;
    #5				
    in_dc = 1'b0;
    in_data = 8'hB0;
    #5
    in_data = 8'h01;
    #5
    in_data = 8'h1F;
    #5		
    in_data = 8'hB0;
    #5
    in_data = 8'h01;
    #5
    in_data = 8'h1F;   
    #5
    in_dc = 1'b1;
    in_data = 8'h12;
    #5
    in_data = 8'h34;
    #5
    in_data = 8'h56;   
    #5
    in_data = 8'h78;

  end
          
  initial begin
 
    in_write = 1'b0;	
    #10

    
    forever begin
      #1 in_write = 1'b1;
      #1 $display("in:%0h, out:%0h",in_data, out_data);
      #1 in_write = 1'b0;		
      #2;
    end
  end
  


endmodule
